﻿using Microsoft.Extensions.Configuration;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;

namespace VA.PPMS.IWS.Api.Configuration
{
    public class IwsConfiguration : IIwsConfiguration
    {
        private readonly IConfiguration _configuration;

        public IwsConfiguration(IConfiguration configuration)
        {
            _configuration = configuration;
        }

        public async Task<string> GetFunctionBaseUriAsync()
        {
            return await GetConfigValue("FunctionBaseUri");
        }

        public async Task<string> GetCcnDataStreamUri()
        {
            return await GetConfigValue("CcnDataStreamUri");
        }

        public async Task<string> GetCcnInitialDocRefUri()
        {
            return await GetConfigValue("CcnInitialDocRefUri");
        }

        public async Task<string> GetDasOperationOutcomeUri()
        {
            return await GetConfigValue("DasOperationOutcomeUri");
        }

        public async Task<string> GetPingUri()
        {
            return await GetConfigValue("PingUri");
        }

        public async Task<string> GetPpmsDataStreamUri()
        {
            return await GetConfigValue("PpmsDataStreamUri");
        }

        public async Task<string> GetAddressValidationCertUrl()
        {
            return await GetConfigValue("AddressValidationCertUrl");
        }

        public async Task<string> GetAddressValidationAppId()
        {
            return await GetConfigValue("AddressValidationAppId");
        }

        public async Task<string> GetAddressValidationSecret()
        {
            return await GetConfigValue("AddressValidationSecret");
        }

        public async Task<string> GetAddressValidationBaseUri()
        {
            return await GetConfigValue("AddressValidationBaseUri");
        }

        public async Task<string> GetAddressValidationRequestUri()
        {
            return await GetConfigValue("AddressValidationRequestUri");
        }

        private async Task<string> GetConfigValue(string configKey)
        {
            await Task.Run(() => {});

            return _configuration[configKey];
        }
    }
}